﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OfflineSettings.aspx.cs" Inherits="ccPublisherWeb.OfflineSettings" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title></title>

   <script language="javascript" type="text/javascript">
      var formValidator = null;
   </script>
</head>
<body>
   <script language="javascript" type="text/javascript" src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.JS.wz_tooltip.js"></script>

   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_Main" runat="server">
         <div id="OfflineSettings">
            <div class="DCenter">
               <h2><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title") %></h2>

               <table class="SettingsTable" border="0" cellpadding="0" cellspacing="0">
                  <tr class="Section">
                     <td colspan="2">
                        <span class="Large"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Section_ProxyLarge") %></span>
                        <span class="Small">
                           <%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Section_ProxySmall") %>
                        </span>
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title_ProxyEnabled") %>:</td>
                     <td class="Value">
                        <asp:CheckBox ID="ckProxyEnabled" runat="server" />
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title_ProxyAddress") %>:</td>
                     <td class="Value">
                        <input type="text" class="Text Http" value="http://" disabled="disabled" /></span><asp:TextBox ID="txProxyAddress" CssClass="Text ProxyField ProxyAddress" Columns="50" runat="server" />
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title_ProxyPort") %>:</td>
                     <td class="Value">
                        <asp:TextBox ID="txProxyPort" CssClass="Text ProxyField" Columns="5" runat="server" />
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title_ProxyUsername") %>:</td>
                     <td class="Value">
                        <asp:TextBox ID="txProxyUsername" CssClass="Text ProxyField" Columns="20" runat="server" />
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Title_ProxyPassword") %>:</td>
                     <td class="Value">
                        <asp:TextBox ID="txProxyPassword" CssClass="Text ProxyField" Columns="20" TextMode="Password" runat="server" />
                     </td>
                  </tr>
                  <tr class="Item">
                     <td class="Title">&nbsp;</td>
                     <td class="Value">
                        <input type="button" value="<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ButtonCheckProxyConnection") %>" onclick="proxyCheck()" />
                     </td>
                  </tr>
               </table>

               <div class="SaveSuccess">
                  <span style="display: none"><%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_Message_SaveSuccess") %></span>
               </div>

               <div class="ButtonPanel">
                  <input id="btSave" type="button" disabled="disabled" value="<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ButtonSave") %>" onclick="saveChanges()" />

                  <div style="display: none">
                     <asp:Button ID="btSaveChanges_Postback" OnClick="SaveChanges_Click" runat="server" />
                  </div>
               </div>
            </div>
         </div>

         <script language="javascript" type="text/javascript">
            function proxyCheck() {
               if(formValidator.Validate()) {
                  <%# ModalProgressID %>.Show();
                  enableScrolling(false);

                  $.ajax({
                     url: "?proxyCheck=1",
                     type: "POST",
                     dataType: "json",
                     cache: false,
                     data: {
                        proxyEnabled: isProxyEnabled() ? "1" : "0",
                        proxyHost: $("#<%# txProxyAddress.ClientID %>").val(),
                        proxyPort: $("#<%# txProxyPort.ClientID %>").val(),
                        proxyUser: $("#<%# txProxyUsername.ClientID %>").val(),
                        proxyPassword: $("#<%# txProxyPassword.ClientID %>").val()
                     },
                     success: function(msgObj) {
                        <%# ModalProgressID %>.Hide();
                        enableScrolling(true);

                        if(msgObj.success == "true") {
                     
                           showMessage("<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheck_DialogTitle") %>", "<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheckOK") %>", MessageBox.Constants.MB_ICON_INFO);
                        } else {
                           showMessage("<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheck_DialogTitle") %>", "<div class='OfflineSettings ErrorScroll'>" + String.format("<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheckFailed") %>", msgObj.errorMessage) + "</div>", MessageBox.Constants.MB_ICON_ERROR);
                        }
                     },
                     error: function (xhr, ajaxOptions, thrownError) {
                        <%# ModalProgressID %>.Hide();
                        enableScrolling(true);

                        if(typeof(callbackFinishedFunction) != "undefined") {
                           callbackFinishedFunction();
                        }
                        showMessage("<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheck_DialogTitle") %>", "<div class='OfflineSettings ErrorScroll'>" + String.format("<%# ccPublisherWeb.TextDic.TxGet("Text_OfflineSettings_ProxyCheckFailed") %>", xhr.status + ": " + thrownError) + "</div>", MessageBox.Constants.MB_ICON_ERROR);
                     } 
                  });
               }
            }

            function showMessage(titleText, messageText, dialogIcon) {
               <%# MessageBoxID %>.Show({
                  title: titleText,
                  messageText: messageText,
                  width: 400,
                  minHeight: 80,
                  icon: dialogIcon,
                  buttons: MessageBox.Constants.MB_OK
               });
            }

            function saveChanges() {
               if(formValidator.Validate()) {
                  enableProxyForm(true);
                  <%# Page.ClientScript.GetPostBackEventReference(btSaveChanges_Postback, "") %>;
               }
            }

            function isProxyEnabled() {
               return $("#<%# ckProxyEnabled.ClientID %>").is(":checked");
            }

            function enableProxyForm(enable) {
               if(enable) {
                  $("INPUT.ProxyField, SELECT.ProxyField").removeAttr("disabled").removeClass("Disabled");
                  $("INPUT.Http").removeClass("Disabled");
               } else {
                  $("INPUT.ProxyField, SELECT.ProxyField").attr("disabled", "disabled").addClass("Disabled");
                  $("INPUT.Http").addClass("Disabled");
               }
            }

            function enableSaveButton(enable) {
               if(enable) {
                  $("#btSave").removeAttr("disabled");
               } else {
                  $("#btSave").attr("disabled", "disabled");
               }
            }

            $(function() {
               enableProxyForm(isProxyEnabled());

               $("#<%# ckProxyEnabled.ClientID %>").click(function() {
                  enableProxyForm(isProxyEnabled());
                  enableSaveButton(true);
               });

               $(".SettingsTable INPUT[type=text], .SettingsTable INPUT[type=password]").keydown(function() {
                  enableSaveButton(true);
               });

               formValidator = new FieldValidator();

               formValidator.Add(new ValidationEvent($("#<%# txProxyAddress.ClientID %>"), function(sender) {
                  return !isProxyEnabled() || (isProxyEnabled() && !String.IsNullOrEmpty(sender.val()));
               }));

               formValidator.Add(new ValidationEvent($("#<%# txProxyPort.ClientID %>"), function(sender) {
                  var port = sender.val();

                  if(isProxyEnabled()) {
                     return !String.IsNullOrEmpty(port) && /^\d*$/.test(port.toString(10));
                  } else {
                     return true;
                  }
               }));

               formValidator.Add(new DummyValidationEvent($("#<%# txProxyUsername.ClientID %>")));
               formValidator.Add(new DummyValidationEvent($("#<%# txProxyPassword.ClientID %>")));

               if(<%# ccPublisherWeb.CommonFunc.JsBool(Page.IsPostBack) %>) {
                  $(".SaveSuccess SPAN").show();
                  setTimeout(function() {
                     $(".SaveSuccess SPAN").fadeOut();
                  }, 800);
               }
            });

            var scrollHTML, scrollBody, scrollForm;

            function enableScrolling(enable) {
               if(enable) {
                  $("HTML").css("overflow", scrollHTML);
                  $("BODY").css("overflow", scrollBody);
                  $("FORM").css("overflow", scrollForm);
               } else {
                  scrollHTML = $("HTML").css("overflow");
                  scrollBody = $("BODY").css("overflow");
                  scrollForm = $("FORM").css("overflow");

                  $("HTML").css("overflow", "hidden");
                  $("BODY").css("overflow", "hidden");
                  $("FORM").css("overflow", "hidden");
               }
            }
         </script>

      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_NonOffline" runat="server">
         <span style="color: red">Not available in online version!</span>
      </asp:PlaceHolder>
   </form>
</body>
</html>
