﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="ccPublisherWeb.CustomBottom" Codebehind="CustomBottom.aspx.cs" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title></title>

   <ccPublisherWeb:CustomerStyleSheet ID="StyleCadViewer" StyleSheetName="CADViewer.css" runat="server" />

   <style type="text/css">
      HTML, BODY, FORM
      {
         height: 100%;
         margin: 0;
         padding: 0;
      }
   </style>

   <!--[if IE 6]>
      <link rel="stylesheet" href="<%# ResolveUrl(ccPublisherWeb.CommonSettings.CustomerStyleFolder + "styleIE6.css") %>" type="text/css" media="screen" />
   <![endif]-->
</head>
<body id="Bottom" class="BottomPage">
   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_CadPreview" runat="server">
         <div id="CADViewer_Display" style="visibility: hidden">
            <div id="TopToolbar" class="CADViewerButtons">
               <div class="Left">
                  <div class="Right">
                     <div class="Center">
                        <input id="ckAutoPrev" onclick="toggleAutoPrevCadWindow(this)" type="checkbox" /><label for="ckAutoPrev"><%# ccPublisherWeb.TextDic.TxGet("Text_PreviewLegend")%></label>

                        <a id="CADViewerButton_DimDrawPDF" href="javascript:;" class="CADViewerButton_DimDrawPDF" onclick="startDimDrawPDF()" title="<%# TextDic.TxGet("Text_CadViewerDimDraw_ButtonPDFDirect_Tooltip") %>"><%# TextDic.TxGet("Text_CadViewerDimDraw_ButtonPDFDirect") %></a>
                     </div>
                  </div>
               </div>
               <div class="Lock"></div>
            </div>

            <div id="CADViewer">
               <div id="Toolbar" class="CADViewerButtons">
                  <div class="Header"></div>
                  <div class="Content">
                     <a href="javascript:;" class="CADViewerButton_Front" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_FRONT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Front") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Right" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_RIGHT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Right") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Top" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_TOP) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Top") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Back" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_BACK) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Back") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Left" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_LEFT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Left") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Bottom" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_BOTTOM) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Bottom") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_Iso" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_ISO) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Isometric") %>"></a>

                     <div class="Spacer"></div>

                     <a href="javascript:;" class="CADViewerButton_3DViewer" onclick="start3DViewerCadWindow()" title="<%# TextDic.TxGet("Text_Ansicht3DVorschau") %>"></a>
                     <a href="javascript:;" class="CADViewerButton_2DViewer" onclick="start2DViewerCadWindow()" title="<%# TextDic.TxGet("Text_Ansicht2DVorschau") %>"></a>
                  </div>
                  <div class="Footer"></div>

                  <div class="Lock"></div>
               </div>
                     
               <asp:Image ID="Prev3DImg" CssClass="Prev3DImg" runat="server" />
            </div>
         </div>
      </asp:PlaceHolder>

      <div class="Container">
         <div class="SpacerLine">
            <div></div>
         </div>
         <div class="KiMText">
            <table border="0" cellpadding="0" cellspacing="0">
               <tr>
                  <td>
                     <a href="#" onclick="window.open('http://www.cadclick.com')">
                        <span>Powered by CADClick<sup>&reg;</sup><asp:Label id="lblServerNumber" style="padding-left:3px" visible="false" runat="server"></asp:Label></span>
                     </a>
                  </td>
               </tr>
            </table>
         </div>
      </div>

      <script language="javascript" type="text/javascript">
         $(function() {
            $("#CADViewer #Toolbar A[vmode]").click(function(event) {
               parent.text.extChangeView($(this).attr("vmode"));
            });
         });

         function swapImage(imgSRC, viewMode, autoPrev) {
            $("#<%# Prev3DImg.ClientID %>").attr("src", imgSRC);
            $("#CADViewer_Display").css("visibility", "visible");
            lockCadViewerToolbar(false);

            $("#CADViewer #Toolbar A[vmode]").toggleClass("Selected", false);
            $("#CADViewer #Toolbar A[vmode=" + viewMode + "]").toggleClass("Selected", true);

            $("#ckAutoPrev").attr("checked", autoPrev);
         }


         function PrevWinHidden() {
            if($("#CADViewer").length) {
               $("#<%# Prev3DImg.ClientID %>").attr("src", "<%# ccPublisherWeb.CommonSettings.CustomerImagesFolder + "prev3d_blank.gif" %>");
               $("#CADViewer_Display").css("visibility", "hidden");
            }
         }


         function lockCadViewerToolbar(show) {
            lockToolbarLeft(show);  
            lockToolbarTop(show);
         }


         function lockToolbarLeft(show) {
            var toolbar = $("#CADViewer #Toolbar");
            var toolbarLock = $("#CADViewer #Toolbar .Lock");

            if(show) {
               toolbarLock.width(toolbar.outerWidth());
               toolbarLock.height(toolbar.outerHeight());

               toolbarLock.show();
            } else {
               toolbarLock.hide();
            }
         }


         function lockToolbarTop(show) {
            var toolbar = $("#TopToolbar");
            var toolbarLock = $("#TopToolbar .Lock");

            if(show) {
               toolbarLock.width(toolbar.outerWidth() - 2);
               toolbarLock.height(toolbar.outerHeight() - 1);

               toolbarLock.show();
               $("#TopToolbar #ckAutoPrev").attr("disabled", "disabled");
            } else {
               toolbarLock.hide();
               $("#TopToolbar #ckAutoPrev").removeAttr("disabled");
            }
         }


         function toggleAutoPrevCadWindow() {
            var state = $("#ckAutoPrev").attr("checked");
            
            try {
               if(parent && parent.text) {
                  parent.text.extChangeAutoPrev(state);
               }
            } catch(e) { }
         }


         function start3DViewerCadWindow() {
            try {
               if(parent && parent.text) {
                  parent.text.start3DViewerExt();
               }
            } catch(e) { }
         }


         function start2DViewerCadWindow() {
            try {
               if(parent && parent.text) {
                  parent.text.start2DViewerExt();
               }
            } catch(e) { }
         }


         function startDimDrawPDF() {
            try {
               if(parent && parent.text) {
                  parent.text.startDimDrawPDFExt();
               }
            } catch(e) { }
         }


         function showCADViewerButton_DimDrawPDF(show) {
            if($("#CADViewerButton_DimDrawPDF").length) {
               if(show) {
                  $("#CADViewerButton_DimDrawPDF").show();
               } else {
                  $("#CADViewerButton_DimDrawPDF").hide();
               }
            }
         }


         function CADPreview() {    
            if (document.CADPrevForm.AutoView.checked) {
               parent.text.document.mainForm.AutoPrevCallExt.value = "true";
                   swap3DViews('ISO');
            } else {
               parent.text.document.mainForm.AutoPrevCallExt.value = "false";
            }
         }
      </script>
   </form>
</body>
</html>
